package net.minecraft.entity.player;

import jamezo97.clonecraft.dna.Gene;
import jamezo97.clonecraft.dna.GenePool;
import jamezo97.clonecraft.dna.IModifiable;
import jamezo97.clonecraft.network.Handler16UpdateGenes;
import net.minecraft.item.ItemInWorldManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;

public class CCEntityPlayerMP extends EntityPlayerMP implements IModifiable, IEntityAdditionalSpawnData{

	public CCEntityPlayerMP(MinecraftServer par1MinecraftServer, World par2World, String par3Str, ItemInWorldManager par4ItemInWorldManager) {
		super(par1MinecraftServer, par2World, par3Str, par4ItemInWorldManager);
		genePool = new GenePool(this);
	}
	
	
	
	public CCEntityPlayerMP(EntityPlayerMP player) {
		super(player.mcServer, player.worldObj, player.username, player.theItemInWorldManager);
		genePool = new GenePool(this);
		NBTTagCompound nbt = new NBTTagCompound();
		player.writeToNBT(nbt);
		this.readFromNBT(nbt);
		this.entityId = player.entityId;
		this.playerNetServerHandler = player.playerNetServerHandler;
		this.playerNetServerHandler.playerEntity = this;
		this.inventory = player.inventory;
		this.inventoryContainer = player.inventoryContainer;
		
	}
	
	float baseSizeX = 0.6F, baseSizeY = 1.8F, geneScaling = 1.0F;
	
	GenePool genePool;
	
	@Override
	public float getBaseStepHeight() {
		return 0.5f;
	}



	public void onUpdate(){
		if(ticksExisted < 2)return;
		genePool.onUpdate();
//		yOffset = 1.62f;
		super.onUpdate();
		
//		this.rotationYaw += 0.2f;
//		System.out.println(ticksExisted);
		
		
	}
	
	
	
	@Override
	public float getBaseYOffset() {
		return 1.62f;
	}
	
	@Override
	public int getGeneStrength(Gene gene) {
		return genePool.getGeneStrength(gene);
	}

	@Override
	public void setGene(Gene gene, int level) {
		genePool.setGene(gene, level);
	}

	@Override
	public boolean removeGene(Gene gene) {
		return genePool.removeGene(gene);
	}

	@Override
	public boolean hasGene(Gene gene) {
		return genePool.hasGene(gene);
	}

	@Override
	public GenePool getGenePool() {
		return genePool;
	}

	@Override
	public void setGeneScaling(float scale) {
		geneScaling = scale;
	}

	@Override
	public float getGeneScaling() {
		return geneScaling;
	}

	@Override
	public float getBaseXSize() {
		return baseSizeX;
	}

	@Override
	public float getBaseYSize() {
		return baseSizeY;
	}

	@Override
	public boolean shouldApplySizeChange() {
		return true;
	}

	@Override
	public void readEntityFromNBT(NBTTagCompound nbt) {
		super.readEntityFromNBT(nbt);
		genePool.readFromNBT(nbt);
	}

	@Override
	public void writeEntityToNBT(NBTTagCompound nbt) {
		super.writeEntityToNBT(nbt);
		genePool.writeToNBT(nbt);
	}

	@Override
	public void writeSpawnData(ByteArrayDataOutput data) {
//		System.out.println("Wrote uname: " + username);
		data.writeUTF(username);
		genePool.writeSpawnData(data);
		
	}

	@Override
	public void readSpawnData(ByteArrayDataInput data) {
		genePool.readSpawnData(data);
	}



	public void updateGenesTo(EntityPlayer mutate) {
		new Handler16UpdateGenes(this, this).sendToClient(mutate);
	}
	
}
